function [Data,Logbook] = SelectBack(handles,image)
% For deconvolution without vacuum ZLP a kernel has to be defined
% otherwise. It can be created by using a region in the background and calculate the mean out of all spectra inside it.
% For noise determination is is very important to mark the pre-ZLP region.
% As no signal is expected there, it can be used to differenciate Gaussion noise from Poisson noise.
% Without any other counts, the Gaussian noise standard deviation can be
% found there.

global tracer tracer1 tracer2

if isempty(tracer) && isempty(tracer1)
    tracer  = 1;
    tracer2 = 1;
else
    Data    = [];
    Logbook = [];
    clearvars -except Data Logbook
    return
end

%% Load File
DenLog = load(fullfile(tempdir,'DenLog.mat')).DenLog ;

%% Get Handles
Data      = get(handles.Background,'UserData');
Pos       = Data{1};
set(handles.Zoom,'UserData',[1,1,size(image,2),size(image,1)]);
Axes      = get(handles.Load,'UserData');
XScale    = size(image,2)*(Axes(1)/2);
YScale    = size(image,1)*(Axes(2)/2);
Energies  = get(handles.ZLPAlign,'UserData');
Logbook   = get(handles.Logbook,'UserData');
%% Calculate Background
UpdatePlot(handles);
if ~isempty(Pos)
    pos(1)=  ( Pos(1)-1)*Axes(1)-XScale;                                   % uses the old rectangle position to show old rectangle
    pos(2)= -( Pos(4)-1)*Axes(2)+YScale;                                   % for the user to change to a new positon
    pos(3)= ( Pos(3)-Pos(1))*Axes(1);
    pos(4)= ( Pos(4)-Pos(2))*Axes(2);
    back  = drawrectangle(handles.Axis,'Position',pos);
else
    back  = drawrectangle(handles.Axis);
end
back.UserData.OnCleanup = onCleanup(@()CleanUp);                       % tracks deleted Object
l = addlistener(back,'ROIClicked',@(src,evt)DoubleClicker(src,evt));       
uiwait;                                                                    % Block program execution
delete(l);                                                                 % Remove listener
try
pos_rect = back.Position;                                                  % Return the current position
catch
    Data    =[];
    Logbook =[];
    clearvars -except Data Logbook
    clear global
    return
end
delete(back);

pos_rect(1) = round(( pos_rect(1)+XScale)/Axes(1))+1;                      % translates the selected rectangle position
pos_rect(2) = round((-pos_rect(2)+YScale)/Axes(2))+1;                      % into pixel numbers
pos_rect(3) = round(pos_rect(3)/Axes(1));
pos_rect(4) = round(pos_rect(4)/Axes(2));

%% Check outsiders
% checks wether the user selected a position outside the image. And if so, resets to image boundary.
xmin =  pos_rect(1);
ymin = (pos_rect(2)-pos_rect(4));
xmax = (pos_rect(1)+pos_rect(3));
ymax =  pos_rect(2);


if xmin<1
    xmin     = 1;
end


if ymin<1
    ymin     = 1;
end


if xmax>size(image,2)
    xmax     = size(image,2);
end


if ymax>size(image,1)
    ymax     = size(image,1);
end

if xmin>xmax
    xmin=xmax;
end

if ymin>ymax
    ymin=ymax;
end

Pos       = [xmin,ymin,xmax,ymax]; 

%% Calculate PreZLP region
Zero = find(Energies>=0,1,'first');
fig  = figure('Name','Select upper boarder of PreZLP region - click to confirm!');
spec = sum(sum(image,1),2);
spec = reshape(spec,[1,size(spec,3)]);

Min = min(spec,[],'all');
if Min<0
    spec = spec-Min+1; % to avoid log(0)
elseif Min==0
    spec = spec+1;
end

spec = real(log(spec));
plot(Energies(1,1:Zero),spec(1,1:Zero),'LineWidth',1.5,'Color','b');
hold on
plot(Energies(1,1:Zero),ones(1,Zero).*min(spec(1,1:Zero)),'--','Color','k');
ylabel( 'Log Counts [a.u.]' );
xlabel( 'Loss energy [eV]' );
legend('Log Spec')
xlim([min(Energies),0]);
hold off
try
    [E,~] = ginput(1);
catch
    Data    = [];
    Logbook = [];
    clearvars -except Data Logbook
    clear global
    return
end
close(fig);
Back = find(Energies>=E,1,'first');

Data={Pos,Back};

%% Create Logbook
Logbook{4}=['Back: Edgepoints: [ ',num2str(Data{1}(1)),' , ', num2str(Data{1}(2)),' , ',num2str(Data{1}(1)+Data{1}(3)),' , ',num2str(Data{1}(2)+Data{1}(4)),' ]  |  PreZLP: ',num2str(Energies(Data{2})),'eV'];

if ~isempty(DenLog)
    DenLog{2} = Logbook{4};
    save(fullfile(tempdir,'DenLog.mat'),'DenLog');
else
    DenLog        = Logbook;
    DenLog{1}     = strrep(DenLog{1},'Org','Denoised');
    DenLog{end+1} = '-----------------------------------------------------------------------------';
    DenLog{end+1} = [];
    DenLog{end+1} = 'SpecDen: None';
    DenLog{end+1} = 'IntDen: None';
    save(fullfile(tempdir,'DenLog.mat'),'DenLog');
end

%% Update Logbook

DeconvLog    = load(fullfile(tempdir,'DeconvLog.mat')).DeconvLog ;
if ~isempty(DeconvLog)
    DeconvLog{4} = Logbook{4};
    save(fullfile(tempdir,'DeconvLog.mat'),'DeconvLog');
end

DecSubLog    = load(fullfile(tempdir,'DeconvLog.mat')).DeconvLog ;
if ~isempty(DecSubLog)
    DecSubLog{4} = Logbook{4};
    save(fullfile(tempdir,'DecSubLog.mat'),'DecSubLog');
end
clearvars -except Data Logbook
end